// DEMODlg.cpp: implementation file 
// 

# include "stdafx.h" 
# include "DEMO.h" 
# include "DEMODlg.h" 
# include "CtrlCard.h" 
# include "BaseParaSet.h" 
# include "IOTest.h" 

# include "adt8960m.h" 

CCtrlCard g_CtrlCard; 

# ifdef _DEBUG 
# define new DEBUG_NEW 
# undef THIS_FILE 
static char THIS_FILE [] = __FILE__; 
# endif 

extern int cardno; // card number 

extern int effectlogic_x; 
extern int effectlogic_y; 
extern int effectlogic_z; 
extern int effectlogic_a; 
extern int effectlogic_b; 
extern int effectlogic_c; 
extern int registermode; 

bool g_bStopFlag = false; 
///////////////////////////////////////////////////////////////////////////// 
// CAboutDlg dialog used for App About 

class CAboutDlg: public CDialog 
{ 
public: 
CAboutDlg (); 

// Dialog Data 
// ((AFX_DATA (CAboutDlg) 
enum {IDD = IDD_ABOUTBOX}; 
//)) AFX_DATA 

// ClassWizard generated virtual function overrides 
// ((AFX_VIRTUAL (CAboutDlg) 
protected: 
virtual void DoDataExchange (CDataExchange * pDX); // DDX / DDV support 
//)) AFX_VIRTUAL 

// Implementation 
protected: 
// ((AFX_MSG (CAboutDlg) 
//)) AFX_MSG 
DECLARE_MESSAGE_MAP () 
}; 

CAboutDlg:: CAboutDlg (): CDialog (CAboutDlg:: IDD) 
{ 
// ((AFX_DATA_INIT (CAboutDlg) 
//)) AFX_DATA_INIT 
} 

void CAboutDlg:: DoDataExchange (CDataExchange * pDX) 
{ 
CDialog:: DoDataExchange (pDX); 
// ((AFX_DATA_MAP (CAboutDlg) 
//)) AFX_DATA_MAP 
} 

BEGIN_MESSAGE_MAP (CAboutDlg, CDialog) 
// ((AFX_MSG_MAP (CAboutDlg) 
// No message handlers 
//)) AFX_MSG_MAP 
END_MESSAGE_MAP () 

///////////////////////////////////////////////////////////////////////////// 
// CDEMODlg dialog 

CDEMODlg:: CDEMODlg (CWnd * pParent /*= NULL */) 
: CDialog (CDEMODlg:: IDD, pParent) 
{ 
// ((AFX_DATA_INIT (CDEMODlg) 
m_nAddX = 0; 
m_nAddY = 0; 
m_nAddZ = 0; 
m_bX = FALSE; 
m_bY = FALSE; 
m_bZ = FALSE; 
m_nPulseX = 0; 
m_nPulseY = 0; 
m_nPulseZ = 0; 
m_nSpeedX = 0; 
m_nSpeedY = 0; 
m_nSpeedZ = 0; 
m_nStartvX = 0; 
m_nStartvY = 0; 
m_nStartvZ = 0; 
m_bDelayStatus = FALSE; 
m_nDelayTime = 0; 
m_nSpeedA = 0; 
m_nStartvA = 0; 
m_nPulseA = 0; 
m_bA = FALSE; 
m_nAddA = 0; 
m_nPulseB = 0; 
m_nPulseC = 0; 
m_bB = FALSE; 
m_bC = FALSE; 
m_nAddB = 0; 
m_nAddC = 0; 
m_nSpeedB = 0; 
m_nSpeedC = 0; 
m_nStartvB = 0; 
m_nStartvC = 0; 
m_nPdir = 0; 
m_dTaccX = 0.0; 
m_dTaccY = 0.0; 
m_dTaccZ = 0.0; 
m_dTaccC = 0.0; 
m_dTaccA = 0.0; 
m_dTaccB = 0.0; 
m_nVaccA = 0; 
m_nVaccB = 0; 
m_nVaccC = 0; 
m_nVaccX = 0; 
m_nVaccY = 0; 
m_nVaccZ = 0; 
m_nAddMode = 0; 
m_bManualContinue = FALSE; 
m_nCardIndex = -1; 
//)) AFX_DATA_INIT 
// Note that LoadIcon does not require a subsequent DestroyIcon in Win32 
m_hIcon = AfxGetApp () -> LoadIcon (IDR_MAINFRAME); 
} 

void CDEMODlg:: DoDataExchange (CDataExchange * pDX) 
{ 
CDialog:: DoDataExchange (pDX); 
// ((AFX_DATA_MAP (CDEMODlg) 
DDX_Control (pDX, IDC_COMBO_CARDNUM, m_ComboCard); 
DDX_Control (pDX, IDC_STATIC_TITLE, m_title); 
DDX_Text (pDX, IDC_ADD_X, m_nAddX); 
DDX_Text (pDX, IDC_ADD_Y, m_nAddY); 
DDX_Text (pDX, IDC_ADD_Z, m_nAddZ); 
DDX_Check (pDX, IDC_CHECK_X, m_bX); 
DDX_Check (pDX, IDC_CHECK_Y, m_bY); 
DDX_Check (pDX, IDC_CHECK_Z, m_bZ); 
DDX_Text (pDX, IDC_PULSE_X, m_nPulseX); 
DDX_Text (pDX, IDC_PULSE_Y, m_nPulseY); 
DDX_Text (pDX, IDC_PULSE_Z, m_nPulseZ); 
DDX_Text (pDX, IDC_SPEED_X, m_nSpeedX); 
DDX_Text (pDX, IDC_SPEED_Y, m_nSpeedY); 
DDX_Text (pDX, IDC_SPEED_Z, m_nSpeedZ); 
DDX_Text (pDX, IDC_STARTV_X, m_nStartvX); 
DDX_Text (pDX, IDC_STARTV_Y, m_nStartvY); 
DDX_Text (pDX, IDC_STARTV_Z, m_nStartvZ); 
DDX_Check (pDX, IDC_CHECK_DELAY, m_bDelayStatus); 
DDX_Text (pDX, IDC_EDIT_DELAYTIME, m_nDelayTime); 
DDX_Text (pDX, IDC_SPEED_A, m_nSpeedA); 
DDX_Text (pDX, IDC_STARTV_A, m_nStartvA); 
DDX_Text (pDX, IDC_PULSE_A, m_nPulseA); 
DDX_Check (pDX, IDC_CHECK_A, m_bA); 
DDX_Text (pDX, IDC_ADD_A, m_nAddA); 
DDX_Text (pDX, IDC_PULSE_B, m_nPulseB); 
DDX_Text (pDX, IDC_PULSE_C, m_nPulseC); 
DDX_Check (pDX, IDC_CHECK_B, m_bB); 
DDX_Check (pDX, IDC_CHECK_C, m_bC); 
DDX_Text (pDX, IDC_ADD_B, m_nAddB); 
DDX_Text (pDX, IDC_ADD_C, m_nAddC); 
DDX_Text (pDX, IDC_SPEED_B, m_nSpeedB); 
DDX_Text (pDX, IDC_SPEED_C, m_nSpeedC); 
DDX_Text (pDX, IDC_STARTV_B, m_nStartvB); 
DDX_Text (pDX, IDC_STARTV_C, m_nStartvC); 
DDX_Radio (pDX, IDC_RADIO_PDIR, m_nPdir); 
DDX_Text (pDX, IDC_TACC_X, m_dTaccX); 
DDX_Text (pDX, IDC_TACC_Y, m_dTaccY); 
DDX_Text (pDX, IDC_TACC_Z, m_dTaccZ); 
DDX_Text (pDX, IDC_TACC_C, m_dTaccC); 
DDX_Text (pDX, IDC_TACC_A, m_dTaccA); 
DDX_Text (pDX, IDC_TACC_B, m_dTaccB); 
DDX_Text (pDX, IDC_VACC_A, m_nVaccA); 
DDX_Text (pDX, IDC_VACC_B, m_nVaccB); 
DDX_Text (pDX, IDC_VACC_C, m_nVaccC); 
DDX_Text (pDX, IDC_VACC_X, m_nVaccX); 
DDX_Text (pDX, IDC_VACC_Y, m_nVaccY); 
DDX_Text (pDX, IDC_VACC_Z, m_nVaccZ); 
DDX_Radio (pDX, IDC_CHECK_TMOVE_TYPE, m_nAddMode); 
DDX_Check (pDX, IDC_CHECK_CONTINUE, m_bManualContinue); 
DDX_CBIndex (pDX, IDC_COMBO_CARDNUM, m_nCardIndex); 
//)) AFX_DATA_MAP 
} 

BEGIN_MESSAGE_MAP (CDEMODlg, CDialog) 
// ((AFX_MSG_MAP (CDEMODlg) 
ON_WM_SYSCOMMAND () 
ON_WM_PAINT () 
ON_WM_QUERYDRAGICON () 
ON_WM_TIMER () 
ON_BN_CLICKED (IDC_BUTTON_PMOVE, OnButtonPmove) 
ON_BN_CLICKED (IDC_BUTTON_INPMOVE, OnButtonInpmove) 
ON_BN_CLICKED (IDC_BUTTON_STOP, OnButtonStop) 
ON_BN_CLICKED (IDC_BUTTON_IOTEST, OnButtonIotest) 
ON_BN_CLICKED (IDC_BUTTON_BASEPARA, OnButtonBasepara) 
ON_BN_CLICKED (IDC_BUTTON_CLEARPOS, OnButtonClearpos) 
ON_BN_CLICKED (IDC_DELAY, OnDelay) 
ON_BN_CLICKED (IDC_BUTTON_CONTINUE, OnButtonContinue) 
ON_BN_CLICKED (IDC_BUTTON_CHANGE, OnButtonChange) 
ON_BN_CLICKED (IDC_BUTTON_ABSOLUTE, OnButtonAbsolute) 
ON_BN_CLICKED (IDC_BUTTON_RELATIVE, OnButtonRelative) 
ON_BN_CLICKED (IDC_CHECK_INP, OnCheckInp) 
ON_BN_CLICKED (IDC_BUTTON_MANUAL, OnButtonManual) 
ON_BN_CLICKED (IDC_BUTTON_LOCKMODE, OnButtonLockmode) 
ON_BN_CLICKED (IDC_BUTTON_LOCKPOS, OnButtonLockpos) 
ON_BN_CLICKED (IDC_BUTTON_CLRLOCK, OnButtonClrlock) 
ON_BN_CLICKED (IDC_BUTTON_FIFO, OnButtonFifo) 
ON_CBN_SELCHANGE (IDC_COMBO_CARDNUM, OnSelchangeComboCardnum) 
//)) AFX_MSG_MAP 
END_MESSAGE_MAP () 

///////////////////////////////////////////////////////////////////////////// 
// CDEMODlg message handlers 

BOOL CDEMODlg:: OnInitDialog () 
{ 
CDialog:: OnInitDialog (); 

// Add "About ..." menu item to system menu. 

// IDM_ABOUTBOX must be in the system command range. 
ASSERT ((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX); 
ASSERT (IDM_ABOUTBOX <0xF000); 

CMenu * pSysMenu = GetSystemMenu (FALSE); 
if (pSysMenu!= NULL) 
{ 
CString strAboutMenu; 
strAboutMenu.LoadString (IDS_ABOUTBOX); 
if (! strAboutMenu.IsEmpty ()) 
{ 
pSysMenu->AppendMenu (MF_SEPARATOR); 
pSysMenu->AppendMenu (MF_STRING, IDM_ABOUTBOX, strAboutMenu); 
} 
} 

// Set the icon for this dialog. The framework does this automatically 
// When the application's main window is not a dialog 
SetIcon (m_hIcon, TRUE); // Set big icon 
SetIcon (m_hIcon, FALSE); // Set small icon 

// TODO: Add extra initialization here 
//************* Set Title ************** 
CWnd * wnd; 
pFont.CreateFont (25,0,0,0,400, FALSE, FALSE, 0, ANSI_CHARSET, OUT_STROKE_PRECIS, CLIP_STROKE_PRECIS, DEFAULT_QUALITY, VARIABLE_PITCH | FF_SWISS, _T ("Arial")); 
    wnd = (CWnd *) GetDlgItem (IDC_STATIC_TITLE); 
wnd->SetFont (& pFont); 

int i; 
CString str; 

i = g_CtrlCard.Init_Board (); 

//************* 8960 card initialized ************** 
if (i <= 0) 
{ 
        MessageBox ("Control card initialization failed!"); 

if (i == 0) 
{ 
MessageBox ("not installed ADT8960 card!"); 
} 
if (i ==- 1) 
{ 
MessageBox ("port driver is not installed!"); 
} 
if (i ==- 2) 
{ 
MessageBox ("PCI bridge fault!"); 
} 
} 
    else 
{ 
for (int j = 0; j <i; j ++); 
{ 

str.Format ("% ld", i); 

MessageBox ("available motion control card number:" + str); 

for (int j = 1; j <= i; j ++) 
{// Add the index of 0-i 
str.Format ("% ld", j-1); 
m_ComboCard.AddString (str); 
} 
m_ComboCard.SetCurSel (0); 
UpdateData (); 
} 

    } 
     

//**************************************** 

 //*************************** Get the version number 
float hardVer; // Hardware version 

g_CtrlCard.Get_Version (hardVer); 
float jj = adt8960_get_hardware_ver (0); 

CStatic * lbl; 

lbl = (CStatic *) GetDlgItem (IDC_INFO_VER); 

str.Format ("Hardware version number:%1.1f\n", hardVer); 

lbl-> SetWindowText (str); 
//**************************************** 

//******* Set the default initial velocity of 1000 ********* 
m_nStartvX = 1000; 
m_nStartvY = 1000; 
m_nStartvZ = 1000; 
m_nStartvA = 1000; 
m_nStartvB = 1000; 
m_nStartvC = 1000; 
//********* Set the default drive speed is 2000 ******** 
m_nSpeedX = 5000; 
m_nSpeedY = 5000; 
m_nSpeedZ = 5000; 
m_nSpeedA = 5000; 
m_nSpeedB = 5000; 
m_nSpeedC = 5000; 
//********* Set the default acceleration 1500 ********** 
m_nAddX = 1500; 
m_nAddY = 1500; 
m_nAddZ = 1500; 
m_nAddA = 1500; 
m_nAddB = 1500; 
m_nAddC = 1500; 
//******** Set the default destination for the 100,000 ****** 
m_nPulseX = 100000; 
m_nPulseY = 100000; 
m_nPulseZ = 100000; 
m_nPulseA = 100000; 
m_nPulseB = 100000; 
m_nPulseC = 100000; 

//******** Set the default destination of 0.01 ****** 
m_dTaccX = 0.01; 
m_dTaccY = 0.01; 
m_dTaccZ = 0.01; 
m_dTaccA = 0.01; 
m_dTaccB = 0.01; 
m_dTaccC = 0.01; 

//********* Set the delay time to 0 ************ 
m_nDelayTime = 0; 

    UpdateData (FALSE); 
//*********** Start timer ************* 
SetTimer (MAINTIMER, 100, NULL); 

return TRUE; // return TRUE unless you set the focus to a control 
} 

void CDEMODlg:: OnSysCommand (UINT nID, LPARAM lParam) 
{ 
if ((nID & 0xFFF0) == IDM_ABOUTBOX) 
{ 
CAboutDlg dlgAbout; 
dlgAbout.DoModal (); 
} 
else 
{ 
CDialog:: OnSysCommand (nID, lParam); 
} 
} 

// If you add a minimize button to your dialog, you will need the code below 
// To draw the icon. For MFC applications using the document / view model, 
// This is automatically done for you by the framework. 

void CDEMODlg:: OnPaint () 
{ 
if (IsIconic ()) 
{ 
CPaintDC dc (this); // device context for painting 

SendMessage (WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc (), 0); 

// Center icon in client rectangle 
int cxIcon = GetSystemMetrics (SM_CXICON); 
int cyIcon = GetSystemMetrics (SM_CYICON); 
CRect rect; 
GetClientRect (& rect); 
int x = (rect.Width () - cxIcon + 1) / 2; 
int y = (rect.Height () - cyIcon + 1) / 2; 

// Draw the icon 
dc.DrawIcon (x, y, m_hIcon); 
} 
else 
{ 
CDialog:: OnPaint (); 
} 
} 

// The system calls this to obtain the cursor to display while the user drags 
// The minimized window. 
HCURSOR CDEMODlg:: OnQueryDragIcon () 
{ 
return (HCURSOR) m_hIcon; 
} 


/********************************* 
           Linkage button action 
*******************************/ 
void CDEMODlg:: OnButtonPmove () 
{ 

UpdateData (TRUE); 

long Startv [] = {m_nStartvX, m_nStartvY, m_nStartvZ, m_nStartvA, m_nStartvB, m_nStartvC}; // initial velocity 

long Speed [] = {m_nSpeedX, m_nSpeedY, m_nSpeedZ, m_nSpeedA, m_nSpeedB, m_nSpeedC}; // drive speed 

long Add [] = {m_nAddX, m_nAddY, m_nAddZ, m_nAddA, m_nAddB, m_nAddC}; // acceleration 

for (int i = 1; i <MAXAXIS +1; i ++) 
{ 
g_CtrlCard.Setup_Speed (i, Startv [i-1], Speed [i-1], Add [i-1], m_nAddMode); 
} 
if (m_bX) 
{ 
//************* X-axis drive ***************// 
g_CtrlCard.Axis_Pmove (1, m_nPulseX); 
} 

if (m_bY) 
{ 
//************* Y axis drive ****************// 
g_CtrlCard.Axis_Pmove (2, m_nPulseY); 
} 
if (m_bZ) 
{ 
//************* Z axis drive **************// 
g_CtrlCard.Axis_Pmove (3, m_nPulseZ); 
} 
if (m_bA) 
{ 
//************* A shaft drive ***************// 
g_CtrlCard.Axis_Pmove (4, m_nPulseA); 
} 
if (m_bB) 
{ 
//************* A shaft drive ***************// 
g_CtrlCard.Axis_Pmove (5, m_nPulseB); 
} 
if (m_bC) 
{ 
//************* A shaft drive ***************// 
g_CtrlCard.Axis_Pmove (6, m_nPulseC); 
} 
} 

/********************************* 
           Interpolation button action 
*********************************/ 
void CDEMODlg:: OnButtonInpmove () 
{ 
UpdateData (); 
// Int status; 
long Startv [] = {m_nStartvX, m_nStartvY, m_nStartvZ, m_nStartvA, m_nStartvB, m_nStartvC}; // initial velocity 

long Speed [] = {m_nSpeedX, m_nSpeedY, m_nSpeedZ, m_nSpeedA, m_nSpeedB, m_nSpeedC}; // drive speed 

long Add [] = {m_nAddX, m_nAddY, m_nAddZ, m_nAddA, m_nAddB, m_nAddC}; // acceleration 

long Pulse [] = {m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nPulseB, m_nPulseC}; // drive shaft pulses 

for (int i = 1; i <MAXAXIS +1; i ++) 
{ 
g_CtrlCard.Setup_Speed (i, Startv [i-1], Speed [i-1], Add [i-1], m_nAddMode); 
} 

    //************ Two-axis interpolation ***********// 
if (m_bX && m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) // XY two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (1, 2, Pulse [0], Pulse [1]); 
} 
else if (m_bX &&! m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) // XZ two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (1, 3, Pulse [0], Pulse [2]); 
} 
else if (m_bX &&! m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) // XA two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (1, 4, Pulse [0], Pulse [3]); 
} 
else if (m_bX &&! m_bY &&! m_bZ &&! m_bA && m_bB &&! m_bC) // XB two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (1, 5, Pulse [0], Pulse [4]); 
} 
else if (m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB && m_bC) // XC two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (1, 6, Pulse [0], Pulse [5]); 
} 
else if (! m_bX && m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) // YZ two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (2, 3, Pulse [1], Pulse [2]); 
} 
else if (! m_bX && m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) // YA two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (2, 4, Pulse [1], Pulse [3]); 
} 
else if (! m_bX && m_bY &&! m_bZ &&! m_bA && m_bB &&! m_bC) // YB two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (2, 5, Pulse [1], Pulse [4]); 
} 
else if (! m_bX && m_bY &&! m_bZ &&! m_bA &&! m_bB && m_bC) // YC two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (2, 6, Pulse [1], Pulse [5]); 
} 
else if (! m_bX &&! m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) // ZA two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (3, 4, Pulse [2], Pulse [3]); 
} 
else if (! m_bX &&! m_bY && m_bZ &&! m_bA && m_bB &&! m_bC) // ZB two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (3, 5, Pulse [2], Pulse [4]); 
} 
else if (! m_bX &&! m_bY && m_bZ &&! m_bA &&! m_bB && m_bC) // ZC two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (3, 6, Pulse [2], Pulse [5]); 
} 
else if (! m_bX &&! m_bY &&! m_bZ && m_bA && m_bB &&! m_bC) // AB two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (4, 5, Pulse [3], Pulse [4]); 
} 
else if (! m_bX &&! m_bY &&! m_bZ && m_bA &&! m_bB && m_bC) // AC two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (4, 6, Pulse [3], Pulse [5]); 
} 
else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA && m_bB && m_bC) // BC two-axis interpolation 
{ 
g_CtrlCard.Interp_Move2 (5, 6, Pulse [4], Pulse [5]); 
} 

    //************* Axis interpolation **************// 
else if (m_bX && m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) // XYZ axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (1, 2, 3, Pulse [0], Pulse [1], Pulse [2]); 
} 
else if (m_bX && m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) // XYA axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (1, 2, 4, Pulse [0], Pulse [1], Pulse [3]); 
} 
else if (m_bX && m_bY &&! m_bZ &&! m_bA && m_bB &&! m_bC) // XYB axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (1, 2, 5, Pulse [0], Pulse [1], Pulse [4]); 
} 
else if (m_bX && m_bY &&! m_bZ &&! m_bA &&! m_bB && m_bC) // XYC axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (1, 2, 6, Pulse [0], Pulse [1], Pulse [5]); 
} 
else if (m_bX &&! m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) // XZA axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (1, 3, 4, Pulse [0], Pulse [2], Pulse [3]); 
} 
else if (m_bX &&! m_bY && m_bZ &&! m_bA && m_bB &&! m_bC) // XZB axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (1, 3, 5, Pulse [0], Pulse [2], Pulse [4]); 
} 
else if (m_bX &&! m_bY && m_bZ &&! m_bA &&! m_bB && m_bC) // XZC axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (1, 3, 6, Pulse [0], Pulse [2], Pulse [5]); 
} 
else if (! m_bX && m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) // YZA axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (2, 3, 4, Pulse [1], Pulse [2], Pulse [3]); 
} 
else if (! m_bX && m_bY && m_bZ &&! m_bA && m_bB &&! m_bC) // YZB axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (2, 3, 5, Pulse [1], Pulse [2], Pulse [4]); 
} 
else if (! m_bX && m_bY && m_bZ &&! m_bA &&! m_bB && m_bC) // YZC axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (2, 3, 6, Pulse [1], Pulse [2], Pulse [5]); 
} 
else if (! m_bX &&! m_bY && m_bZ && m_bA && m_bB &&! m_bC) // ZAB axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (3, 4, 5, Pulse [2], Pulse [3], Pulse [4]); 
} 
else if (! m_bX &&! m_bY && m_bZ && m_bA &&! m_bB && m_bC) // ZAC axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (3, 4, 6, Pulse [2], Pulse [3], Pulse [5]); 
} 
else if (! m_bX &&! m_bY &&! m_bZ && m_bA && m_bB && m_bC) // ABC three-axis interpolation 
{ 
g_CtrlCard.Interp_Move3 (4, 5, 6, Pulse [3], Pulse [4], Pulse [5]); 
} 

    //************ Axis interpolation *************// 
else if (m_bX && m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) // XYZA axis interpolation 
{ 
g_CtrlCard.Interp_Move4 (1,2,3,4, Pulse [0], Pulse [1], Pulse [2], Pulse [3]); 
} 
//************ Axis interpolation *************// 
else if (m_bX && m_bY && m_bZ && m_bA && m_bB &&! m_bC) // XYZAB five-axis interpolation 
{ 
g_CtrlCard.Interp_Move5 (1,2,3,4,5, Pulse [0], Pulse [1], Pulse [2], Pulse [3], Pulse [4]); 
} 
//************ Six-axis interpolation *************// 
else if (m_bX && m_bY && m_bZ && m_bA && m_bB && m_bC) // XYZABC six-axis interpolation 
{ 
g_CtrlCard.Interp_Move6 (Pulse [0], Pulse [1], Pulse [2], Pulse [3], Pulse [4], Pulse [5]); 
} 
else 
{ 
MessageBox ("here only shows part of the axis, select the interpolation axis!", "Prompt"); 
} 

} 
/******************************** 
Stop button action 
Stop for each axis 
********************************/ 
void CDEMODlg:: OnButtonStop () 
{ 
g_bStopFlag = true; 
    adt8960_reset_fifo (0); 

for (int i = 1; i <= MAXAXIS; i ++) 
{ 
       g_CtrlCard.StopRun (i, 0); 
} 
} 
//******************** Real-time access to state ************************* // 
// Get the logical position, actual position, speed and drive status // 
// Read positive and negative limit, stop0, stop1 signal // 
//************************************************ *********// 
void CDEMODlg:: OnTimer (UINT nIDEvent) 
{ 
long log = 0, act = 0, spd = 0; 
UINT nID1 [] = {IDC_POS_LOGX, IDC_POS_LOGY, IDC_POS_LOGZ, IDC_POS_LOGA, IDC_POS_LOGB, IDC_POS_LOGC}; 
UINT nID2 [] = {IDC_POS_ACTX, IDC_POS_ACTY, IDC_POS_ACTZ, IDC_POS_ACTA, IDC_POS_ACTB, IDC_POS_ACTC}; 
UINT nID3 [] = {IDC_RUNSPEED_X, IDC_RUNSPEED_Y, IDC_RUNSPEED_Z, IDC_RUNSPEED_A, IDC_RUNSPEED_B, IDC_RUNSPEED_C}; 
CStatic * lbl; 
CString str; 
int status [6]; 
 for (int i = 1; i <MAXAXIS +1; i ++) 
{ 
g_CtrlCard.Get_CurrentInf (i, log, act, spd); // read the logical location, the actual position and speed 

//******** Show logical location ********// 
lbl = (CStatic *) GetDlgItem (nID1 [i-1]); 

str.Format ("% ld", log); 

lbl-> SetWindowText (str); 

//******** Show the actual location of ********// 
lbl = (CStatic *) GetDlgItem (nID2 [i-1]); 

str.Format ("% ld", act); 

lbl-> SetWindowText (str); 

//******** Display speed ********// 
lbl = (CStatic *) GetDlgItem (nID3 [i-1]); 

str.Format ("% ld", spd); 

lbl-> SetWindowText (str); 

////*********Get driving state ******** 
g_CtrlCard.Get_Status (i, status [i-1], 0); 

} 
    //****************** Signal detection ***************** 
    // X axis is the limit -0 X-axis negative limit -1 
    // X axis STOP0 -2 X-axis STOP1 -3 
    // Y axis is the negative limit limit -5 -4 Y-axis 
    // Y axis STOP0 -6 Y-axis STOP1 -7 
    // Z-axis is the negative limit limit -9 -8 Z-axis 
    // Z axis STOP0 -10 Z-axis STOP1 -11 
    // A-axis is the negative limit limit -13 -12 A-axis 
    // A-axis STOP0 -14 A shaft STOP1 -15 
// B-axis is the negative limit limit -17 -16 B-axis 
    // B-axis STOP0 -18 B-axis STOP1 -19 
// C-axis is the limit -21 -20 C-axis negative limit 
    // C-axis STOP0 -22 C axis STOP1 -23 
    //******************************************* 
 UINT nIDIN [] = {IDC_LIMIT_X, IDC_LIMIT_X2, // X-axis positive and negative limit 
IDC_STOP0_X, IDC_STOP1_X, 
IDC_LIMIT_Y, IDC_LIMIT_Y2, // Y axes limit 
IDC_STOP0_Y, IDC_STOP1_Y, 
IDC_LIMIT_Z, IDC_LIMIT_Z2, // Z axes limit 
IDC_STOP0_Z, IDC_STOP1_Z, 
IDC_LIMIT_A, IDC_LIMIT_A2, // A axes limit 
IDC_STOP0_A, IDC_STOP1_A, 
IDC_LIMIT_B, IDC_LIMIT_B2, // B axes limit 
IDC_STOP0_B, IDC_STOP1_B, 
IDC_LIMIT_C, IDC_LIMIT_C2, // C axes limit 
IDC_STOP0_C, IDC_STOP1_C, 
}; 

 int io [] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21, 22,23}; 

CButton * btn; 
int value; 

for (i = 0; i <24; i ++) 
{ 
value = g_CtrlCard.Read_Input (io [i]); // read signal 

btn = (CButton *) GetDlgItem (nIDIN [i]); 

btn-> SetCheck (value == 0? 1:0); 
} 

    //************************** Button control ******************** ******** 
if (status [0] == 0 && status [1] == 0 && status [2] == 0 && status [3] == 0 && status [4] == 0 && status [5] == 0) 
{ 
//**************** Driver completed **************** 
btn = (CButton *) GetDlgItem (IDC_BUTTON_PMOVE); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_INPMOVE); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_CLEARPOS); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_BASEPARA); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_IOTEST); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_CONTINUE); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_ABSOLUTE); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_RELATIVE); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_CHECK_INP); 

btn-> EnableWindow (TRUE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_FIFO); 

btn-> EnableWindow (TRUE); 

} 

else 
{ 
//********** Drive to the ********** 
btn = (CButton *) GetDlgItem (IDC_BUTTON_PMOVE); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_INPMOVE); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_CLEARPOS); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_BASEPARA); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_IOTEST); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_CONTINUE); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_ABSOLUTE); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_RELATIVE); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_CHECK_INP); 

btn-> EnableWindow (FALSE); 

btn = (CButton *) GetDlgItem (IDC_BUTTON_FIFO); 

btn-> EnableWindow (FALSE); 
} 

CDialog:: OnTimer (nIDEvent); 
} 

void CDEMODlg:: OnButtonIotest () 
{ 
CIOTest dlg; 

dlg.DoModal (); 
} 

void CDEMODlg:: OnButtonBasepara () 
{ 
CBaseParaSet dlg; 

dlg.DoModal (); 
} 

void CDEMODlg:: OnButtonClearpos () 
{ 
for (int i = 1; i <MAXAXIS +1; i ++) 
{ 
g_CtrlCard.Setup_Pos (i, 0, 0); // logical position is set to zero 

g_CtrlCard.Setup_Pos (i, 0, 1); // actual position is set to zero 
} 

} 

void CDEMODlg:: OnDelay () 
{ 
UpdateData (); 

g_CtrlCard.Setup_Delay (m_nDelayTime); 

while (true) 
{ 
DoEvent (); 

m_bDelayStatus = g_CtrlCard.Get_DelayStatus (); 
UpdateData (FALSE); 
if (m_bDelayStatus == false) 
break; 
} 

} 


void CDEMODlg:: OnButtonContinue () 
{ 
UpdateData (TRUE); 

long Startv [] = {m_nStartvX, m_nStartvY, m_nStartvZ, m_nStartvA, m_nStartvB, m_nStartvC}; // initial velocity 

long Speed [] = {m_nSpeedX, m_nSpeedY, m_nSpeedZ, m_nSpeedA, m_nSpeedB, m_nSpeedC}; // drive speed 

long Add [] = {m_nAddX, m_nAddY, m_nAddZ, m_nAddA, m_nAddB, m_nAddC}; // acceleration 

for (int i = 1; i <MAXAXIS +1; i ++) 
{ 
g_CtrlCard.Setup_Speed (i, Startv [i-1], Speed [i-1], Add [i-1], m_nAddMode); 
} 
if (m_bX) 
{ 
//************* X-axis drive ***************// 
g_CtrlCard.Axis_ConMove (1, m_nPdir); 
} 

if (m_bY) 
{ 
//************* Y axis drive ****************// 
g_CtrlCard.Axis_ConMove (2, m_nPdir); 
} 
if (m_bZ) 
{ 
 //************* Z axis drive **************// 
g_CtrlCard.Axis_ConMove (3, m_nPdir); 
} 
if (m_bA) 
{ 
//************* A shaft drive ***************// 
g_CtrlCard.Axis_ConMove (4, m_nPdir); 
} 
if (m_bB) 
{ 
//************* B-axis drive ***************// 
g_CtrlCard.Axis_ConMove (5, m_nPdir); 
} 
if (m_bC) 
{ 
//************* C-axis drive ***************// 
g_CtrlCard.Axis_ConMove (6, m_nPdir); 
} 
} 

void CDEMODlg:: OnButtonChange () 
{ 

UpdateData (TRUE); 

long Speed [] = {m_nSpeedX, m_nSpeedY, m_nSpeedZ, m_nSpeedA, m_nSpeedB, m_nSpeedC}; // drive speed 

for (int i = 1; i <MAXAXIS +1; i ++) 
{ 
adt8960_set_speed (0, i, Speed [i-1]); 
} 
} 

void CDEMODlg:: OnButtonAbsolute () 
{ 
UpdateData (TRUE); 

if (m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteMove (1, m_nPulseX, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
if (m_bY &&! m_bX &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteMove (2, m_nPulseY, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
if (m_bZ &&! m_bY &&! m_bX &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteMove (3, m_nPulseZ, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccZ, m_nAddMode == 0? 0:1); 
} 
if (m_bA &&! m_bY &&! m_bZ &&! m_bX &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteMove (4, m_nPulseA, m_nStartvA, m_nSpeedA, m_dTaccA, m_nVaccA, m_nAddMode == 0? 0:1); 
} 
if (m_bB &&! m_bY &&! m_bZ &&! m_bA &&! m_bX &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteMove (5, m_nPulseB, m_nStartvB, m_nSpeedB, m_dTaccB, m_nVaccB, m_nAddMode == 0? 0:1); 
} 
if (m_bC &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bX) 
{ 
g_CtrlCard.Sym_AbsoluteMove (6, m_nPulseC, m_nStartvC, m_nSpeedC, m_dTaccC, m_nVaccC, m_nAddMode == 0? 0:1); 
} 

else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
MessageBox ("axis is not selected!"); 
} 
} 

void CDEMODlg:: OnButtonRelative () 
{ 
UpdateData (TRUE); 

// Single-axis drive 
if (m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeMove (1, m_nPulseX, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
if (m_bY &&! m_bX &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeMove (2, m_nPulseY, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
if (m_bZ &&! m_bY &&! m_bX &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeMove (3, m_nPulseZ, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccZ, m_nAddMode == 0? 0:1); 
} 
if (m_bA &&! m_bY &&! m_bZ &&! m_bX &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeMove (4, m_nPulseA, m_nStartvA, m_nSpeedA, m_dTaccA, m_nVaccA, m_nAddMode == 0? 0:1); 
} 

if (m_bB &&! m_bY &&! m_bZ &&! m_bA &&! m_bX &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeMove (5, m_nPulseB, m_nStartvB, m_nSpeedB, m_dTaccB, m_nVaccB, m_nAddMode == 0? 0:1); 
} 
if (m_bC &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bX) 
{ 
g_CtrlCard.Sym_RelativeMove (6, m_nPulseC, m_nStartvC, m_nSpeedC, m_dTaccC, m_nVaccC, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA) 
{ 
MessageBox ("axis is not selected!"); 
} 
} 

void CDEMODlg:: OnCheckInp () 
{ 
UpdateData (TRUE); 

CButton * btn; 

btn = (CButton *) GetDlgItem (IDC_CHECK_INP); 

if (btn-> GetCheck ()) 
{ 
btn-> SetWindowText ("absolute motion interpolation"); 

if (m_bX && m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) // absolute motion of two-axis interpolation 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (1, 2, m_nPulseX, m_nPulseY, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (1, 3, m_nPulseX, m_nPulseZ, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (1, 4, m_nPulseX, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY &&! m_bZ &&! m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (1, 5, m_nPulseX, m_nPulseB, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (1, 6, m_nPulseX, m_nPulseC, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 

else if (! m_bX && m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (2, 3, m_nPulseY, m_nPulseZ, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (2, 4, m_nPulseY, m_nPulseA, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY &&! m_bZ &&! m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (2, 5, m_nPulseY, m_nPulseB, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY &&! m_bZ &&! m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (2, 6, m_nPulseY, m_nPulseC, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 

else if (! m_bX &&! m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (3, 4, m_nPulseZ, m_nPulseA, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccZ, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY && m_bZ &&! m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (3, 5, m_nPulseZ, m_nPulseB, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccZ, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY && m_bZ &&! m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (3, 6, m_nPulseZ, m_nPulseC, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ && m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (4, 5, m_nPulseA, m_nPulseB, m_nStartvA, m_nSpeedA, m_dTaccA, m_nVaccA, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ && m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (4, 6, m_nPulseA, m_nPulseC, m_nStartvA, m_nSpeedA, m_dTaccA, m_nVaccA, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA && m_bB && m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine2 (5, 6, m_nPulseB, m_nPulseC, m_nStartvB, m_nSpeedB, m_dTaccB, m_nVaccB, m_nAddMode == 0? 0:1); 
} 

else if (m_bX && m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) // axis absolute motion interpolation 
{ 
g_CtrlCard.Sym_AbsoluteLine3 (1, 2, 3, m_nPulseX, m_nPulseY, m_nPulseZ, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX && m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine3 (1, 2, 4, m_nPulseX, m_nPulseY, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine3 (1, 3, 4, m_nPulseX, m_nPulseZ, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_AbsoluteLine3 (2, 3, 4, m_nPulseY, m_nPulseZ, m_nPulseA, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (m_bX && m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) // axis absolute motion interpolation 
{ 
g_CtrlCard.Sym_AbsoluteLine4 (1,2,3,4, m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX && m_bY && m_bZ && m_bA && m_bB &&! m_bC) // axis absolute motion interpolation 
{ 
g_CtrlCard.Sym_AbsoluteLine5 (1,2,3,4,5, m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nPulseB, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX && m_bY && m_bZ && m_bA && m_bB && m_bC) // six-axis absolute motion interpolation 
{ 
g_CtrlCard.Sym_AbsoluteLine6 (m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nPulseB, m_nPulseC, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 

else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
MessageBox ("here is only part of the shaft to achieve the function, select on the interpolation axis!"); 
} 
} 
else // relative motion of two-axis interpolation 
{ 
btn-> SetWindowText ("relative motion interpolation"); 

if (m_bX && m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (1, 2, m_nPulseX, m_nPulseY, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (1, 3, m_nPulseX, m_nPulseZ, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (1, 4, m_nPulseX, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY &&! m_bZ &&! m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (1, 5, m_nPulseX, m_nPulseB, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (1, 6, m_nPulseX, m_nPulseC, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 

else if (! m_bX && m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (2, 3, m_nPulseY, m_nPulseZ, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (2, 4, m_nPulseY, m_nPulseA, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY &&! m_bZ &&! m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (2, 5, m_nPulseY, m_nPulseB, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY &&! m_bZ &&! m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (2, 6, m_nPulseY, m_nPulseC, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (3, 4, m_nPulseZ, m_nPulseA, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccZ, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY && m_bZ &&! m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (3, 5, m_nPulseZ, m_nPulseB, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccZ, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY && m_bZ &&! m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (3, 6, m_nPulseZ, m_nPulseC, m_nStartvZ, m_nSpeedZ, m_dTaccZ, m_nVaccZ, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ && m_bA && m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (4, 5, m_nPulseA, m_nPulseB, m_nStartvA, m_nSpeedA, m_dTaccA, m_nVaccA, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ && m_bA &&! m_bB && m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (4, 6, m_nPulseA, m_nPulseC, m_nStartvA, m_nSpeedA, m_dTaccA, m_nVaccA, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA && m_bB && m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine2 (5, 6, m_nPulseB, m_nPulseC, m_nStartvB, m_nSpeedB, m_dTaccB, m_nVaccB, m_nAddMode == 0? 0:1); 
} 

if (m_bX && m_bY && m_bZ &&! m_bA &&! m_bB &&! m_bC) // axis relative motion interpolation 
{ 
g_CtrlCard.Sym_RelativeLine3 (1, 2, 3, m_nPulseX, m_nPulseY, m_nPulseZ, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX && m_bY &&! m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine3 (1, 2, 4, m_nPulseX, m_nPulseY, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 

else if (m_bX &&! m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine3 (1, 3, 4, m_nPulseX, m_nPulseZ, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX && m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Sym_RelativeLine3 (2, 3, 4, m_nPulseY, m_nPulseZ, m_nPulseA, m_nStartvY, m_nSpeedY, m_dTaccY, m_nVaccY, m_nAddMode == 0? 0:1); 
} 

else if (m_bX && m_bY && m_bZ && m_bA &&! m_bB &&! m_bC) // axis relative motion interpolation 
{ 
g_CtrlCard.Sym_RelativeLine4 (1,2,3,4, m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX && m_bY && m_bZ && m_bA && m_bB &&! m_bC) // axis relative motion interpolation 
{ 
g_CtrlCard.Sym_RelativeLine5 (1,2,3,4, 5, m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nPulseB, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (m_bX && m_bY && m_bZ && m_bA && m_bB && m_bC) // six-axis relative motion interpolation 
{ 
g_CtrlCard.Sym_RelativeLine6 (m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nPulseB, m_nPulseC, m_nStartvX, m_nSpeedX, m_dTaccX, m_nVaccX, m_nAddMode == 0? 0:1); 
} 
else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
MessageBox ("here is only part of the shaft to achieve the function, select on the interpolation axis!"); 
} 
} 

} 

/* 
// Manual driver 
void CDEMODlg:: OnButtonManual () 
{ 
static bool manual = false; 
int axis = 0; 
UpdateData (TRUE); 

    if (! m_bX &&! m_bY &&! m_bZ &&! m_bA) 
{ 
MessageBox ("Please select the drive shaft!"); 
return; 
} 

UpdateData (TRUE); 

long Startv [] = (m_nStartvX, m_nStartvY, m_nStartvZ, m_nStartvA, m_nStartvB, m_nStartvC); // initial velocity 

long Speed [] = (m_nSpeedX, m_nSpeedY, m_nSpeedZ, m_nSpeedA, m_nSpeedB, m_nSpeedC); // drive speed 

long Add [] = (m_nAddX, m_nAddY, m_nAddZ, m_nAddA, m_nAddB, m_nAddC); // acceleration 

if (m_bX) 
{ 
axis = 1; 
} 
else if (m_bY) 
{ 
axis = 2; 
} 
else if (m_bZ) 
{ 
axis = 3; 
} 
else if (m_bA) 
{ 
axis = 4; 
} 
else if (m_bB) 
{ 
axis = 5; 
} 
else 
{ 
axis = 6; 
} 
for (int i = 1; i <7; i ++) 
{ 
if (i! = axis) 
{ 
g_CtrlCard.Manu_Disable (i); 
} 
} 

g_CtrlCard.Setup_Speed (axis, m_nStartvX, m_nSpeedX, m_nAddX, m_nAddMode); // speed setting 

manual =! manual; 

GetDlgItem (IDC_BUTTON_MANUAL) -> SetWindowText (manual? "Enable manual driven": "Disable manual driver"); 
if (manual) 
{ 
if (! m_bManualContinue) 
{ 
g_CtrlCard.Manu_Pmove (axis, 1000); // drive manual quantitative 
} 
else 
{ 
g_CtrlCard.Manu_Continue (axis); // drive manual continuous 
} 

} 
else 
{ 
for (i = 1; i <7; i ++) 
{ 
g_CtrlCard.Manu_Disable (i); 
} 
} 
} 
// */ 

void CDEMODlg:: OnButtonManual () 
{ 
    static bool manual = false; 
    int i; 

UpdateData (TRUE); 

    if (! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
MessageBox ("Please select the drive shaft!"); 
return; 
} 

UpdateData (TRUE); 

long Startv [] = {m_nStartvX, m_nStartvY, m_nStartvZ, m_nStartvA, m_nStartvB, m_nStartvC}; // initial velocity 

long Speed [] = {m_nSpeedX, m_nSpeedY, m_nSpeedZ, m_nSpeedA, m_nSpeedB, m_nSpeedC}; // drive speed 

long Add [] = {m_nAddX, m_nAddY, m_nAddZ, m_nAddA, m_nAddB, m_nAddC}; // acceleration 

long Pulse [] = {m_nPulseX, m_nPulseY, m_nPulseZ, m_nPulseA, m_nPulseB, m_nPulseC}; // pulse 

manual =! manual; 

GetDlgItem (IDC_BUTTON_MANUAL)->SetWindowText (manual? "Enable manual driven": "Disable manual driver"); 
if (manual) 
{ 
if (! m_bManualContinue) 
{ 
if (m_bX) 
{ 
g_CtrlCard.Setup_Speed (1, Startv [0], Speed [0], Add [0], m_nAddMode); 
g_CtrlCard.Manu_Pmove (1, Pulse [0]); // X-driven manual quantitative 
} 
if (m_bY) 
{ 
g_CtrlCard.Setup_Speed (2, Startv [1], Speed [1], Add [1], m_nAddMode); 
g_CtrlCard.Manu_Pmove (2, Pulse [1]); // Y manual quantitative driver 
} 
if (m_bZ) 
{ 
g_CtrlCard.Setup_Speed (3, Startv [2], Speed [2], Add [2], m_nAddMode); 
g_CtrlCard.Manu_Pmove (3, Pulse [2]); // Z quantitative driver manual 
} 
if (m_bA) 
{ 
g_CtrlCard.Setup_Speed (4, Startv [3], Speed [3], Add [3], m_nAddMode); 
g_CtrlCard.Manu_Pmove (4, Pulse [3]); // A manual of quantitative-driven 
} 
if (m_bB) 
{ 
g_CtrlCard.Setup_Speed (5, Startv [4], Speed [4], Add [4], m_nAddMode); 
g_CtrlCard.Manu_Pmove (5, Pulse [4]); // B manual quantitative driver 
} 
if (m_bC) 
{ 
g_CtrlCard.Setup_Speed (6, Startv [5], Speed [5], Add [5], m_nAddMode); 
g_CtrlCard.Manu_Pmove (6, Pulse [5]); // C manual quantitative driver 
} 
} 
else 
{ 
if (m_bX) 
{ 
g_CtrlCard.Setup_Speed (1, Startv [0], Speed [0], Add [0], m_nAddMode); 
g_CtrlCard.Manu_Continue (1); // X manual continuous drive 
} 
if (m_bY) 
{ 
g_CtrlCard.Setup_Speed (2, Startv [1], Speed [1], Add [1], m_nAddMode); 
g_CtrlCard.Manu_Continue (2); // Y manual continuous drive 
} 
if (m_bZ) 
{ 
g_CtrlCard.Setup_Speed (3, Startv [2], Speed [2], Add [2], m_nAddMode); 
g_CtrlCard.Manu_Continue (3); // Z manual continuous drive 
} 
if (m_bA) 
{ 
g_CtrlCard.Setup_Speed (4, Startv [3], Speed [3], Add [3], m_nAddMode); 
g_CtrlCard.Manu_Continue (4); // A continuous drive manual 
} 
if (m_bB) 
{ 
g_CtrlCard.Setup_Speed (5, Startv [4], Speed [4], Add [4], m_nAddMode); 
g_CtrlCard.Manu_Continue (4); // B manual continuous drive 
} 
if (m_bC) 
{ 
g_CtrlCard.Setup_Speed (6, Startv [5], Speed [5], Add [5], m_nAddMode); 
g_CtrlCard.Manu_Continue (5); // C manual continuous drive 
} 
} 

} 
else 
{ 
for (i = 1; i <7; i ++) 
{ 
g_CtrlCard.Manu_Disable (i); 
} 
} 
} 

// Position latch mode 
void CDEMODlg:: OnButtonLockmode () 
{ 
UpdateData (TRUE); 

if (m_bX) 
{ 
g_CtrlCard.Setup_LockPosition (1,1, registermode, effectlogic_x); 
} 
if (m_bY) 
{ 
g_CtrlCard.Setup_LockPosition (2,1, registermode, effectlogic_y); 
} 
if (m_bZ) 
{ 
g_CtrlCard.Setup_LockPosition (3,1, registermode, effectlogic_z); 
} 
if (m_bA) 
{ 
g_CtrlCard.Setup_LockPosition (4,1, registermode, effectlogic_a); 
} 
if (m_bB) 
{ 
g_CtrlCard.Setup_LockPosition (5,1, registermode, effectlogic_b); 
} 
if (m_bC) 
{ 
g_CtrlCard.Setup_LockPosition (6,1, registermode, effectlogic_c); 
} 
else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
MessageBox ("Please select the latch shaft!"); 
} 
} 

// Latch position 
void CDEMODlg:: OnButtonLockpos () 
{ 
    int status = 0; 

long posx, posy, posz, posa, posb, posc; 

CString str; 

UpdateData (TRUE); 

    if (m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Get_LockStatus (1, status); 
} 
if (m_bY &&! m_bX &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Get_LockStatus (2, status); 
} 
if (m_bZ &&! m_bX &&! m_bY &&! m_bA &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Get_LockStatus (3, status); 
} 
if (m_bA &&! m_bX &&! m_bY &&! m_bZ &&! m_bB &&! m_bC) 
{ 
g_CtrlCard.Get_LockStatus (4, status); 
} 
if (m_bB &&! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bC) 
{ 
g_CtrlCard.Get_LockStatus (5, status); 
} 
if (m_bC &&! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB) 
{ 
g_CtrlCard.Get_LockStatus (6, status); 
} 
if (status) 
{ 
g_CtrlCard.Get_LockPosition (1, posx); 
g_CtrlCard.Get_LockPosition (2, posy); 
g_CtrlCard.Get_LockPosition (3, posz); 
g_CtrlCard.Get_LockPosition (4, posa); 
g_CtrlCard.Get_LockPosition (5, posb); 
g_CtrlCard.Get_LockPosition (6, posc); 

str.Format ("x:% ld, y:% ld, z:% ld, a:% ld, b:% ld, c:% ld", posx, posy, posz, posa, posb, posc); 

MessageBox (str, "latched position"); 
} 
else if (! m_bX &&! m_bY &&! m_bZ &&! m_bA &&! m_bB &&! m_bC) 
{ 
MessageBox ("Please select the location of latch shaft!"); 
} 
} 

// Latch is cleared 
void CDEMODlg:: OnButtonClrlock () 
{ 
for (int i = 1; i <MAXAXIS +1; i ++) 
{ 
g_CtrlCard.Clr_LockPosition (i); 
} 
} 


// Hardware cache example, will be split into sections of a straight line 
// Cache data will run as long as the instruction cache instruction 
// NOTE: cache command to stop, need to clear the contents have been cached, and then stop the pulse 
void CDEMODlg:: OnButtonFifo () 
{// Will split into 50 segments in a straight line 
g_bStopFlag = false; 
// Int val1, val2; 
int m = adt8960_reset_fifo (0); // clear the cache 
for (int i = 0; i <50;) 
{// Data processing section 50 
if (adt8960_read_fifo_full (0) == 0) // 0: less than, 1: full 
{// Read cache is full 
m = adt8960_fifo_inp_move1 (0,1,100,3000); 
i ++; 
} 
else 
{ 
MessageBox ("the cache is full, later stored"); 
break; 
} 
:: DoEvent (); 
if (g_bStopFlag) 
break; 
} 

/* //////////////////////////////////// 
CStatic * lbl; 
CString str; 
lbl = (CStatic *) GetDlgItem (IDC_STATIC_FIFONO); 

val2 = read_fifo_empty (0); // 0: non-empty, 1: Empty 
while (val2! = 1) 
{// Cache when there are data execution status display buffer 
:: DoEvent (); 
read_fifo_count (0, & val1); 
val2 = read_fifo_empty (0); 

val1 = i-val1 / 3; // i is put to the cache instruction, where instruction cache of 1-axis 
TRACE ("v1:%d\n", val1); // how many have been implemented instruction cache 

str.Format ("number of articles that have been implemented cache:% d", val1); 
if (val1> 0 && val1 <i +1) 
{ 
lbl-> SetWindowText (str); 
} 
if (val2 == 1) break; 
if (g_bStopFlag) return; 
} 
// */ 
} 

void CDEMODlg:: OnSelchangeComboCardnum () 
{ 
UpdateData (); 
cardno = m_nCardIndex; 
TRACE ("% ld", cardno); 

} 
